/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.business.BusinessService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundBusinessPublicRegisterPageChangePacket {
    private final int pageNumber;

    public ServerBoundBusinessPublicRegisterPageChangePacket(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundBusinessPublicRegisterPageChangePacket decode(FriendlyByteBuf buffer) {
        int pageNumber = buffer.readInt();
        return new ServerBoundBusinessPublicRegisterPageChangePacket(pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            BusinessService service = Services.getService(BusinessService.class);
            service.showBusinessRegisterPage((OnlinePlayer)p, this.pageNumber);
        });
    }
}

