/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.BusinessOwnershipType;
import com.equestricraft.core.business.registration.BusinessRegistrationRequestDto;
import com.equestricraft.mod.business.BusinessService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundBusinessRegistrationRequestPacket {
    private final BusinessRegistrationRequestDto registrationRequest;

    public ServerBoundBusinessRegistrationRequestPacket(BusinessRegistrationRequestDto registrationRequest) {
        this.registrationRequest = registrationRequest;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.registrationRequest.businessName());
        buffer.m_130068_((Enum)this.registrationRequest.ownershipType());
        buffer.m_130070_(this.registrationRequest.businessName());
        buffer.writeInt(this.registrationRequest.categoryIds().size());
        for (Integer categoryId : this.registrationRequest.categoryIds()) {
            buffer.writeInt(categoryId.intValue());
        }
    }

    public static ServerBoundBusinessRegistrationRequestPacket decode(FriendlyByteBuf buffer) {
        String businessName = buffer.m_130277_();
        BusinessOwnershipType ownershipType = (BusinessOwnershipType)buffer.m_130066_(BusinessOwnershipType.class);
        String requestBody = buffer.m_130277_();
        int categoryCount = buffer.readInt();
        ArrayList<Integer> categoryIds = new ArrayList<Integer>(categoryCount);
        for (int i = 0; i < categoryCount; ++i) {
            categoryIds.add(buffer.readInt());
        }
        BusinessRegistrationRequestDto registrationRequest = new BusinessRegistrationRequestDto(businessName, ownershipType, requestBody, categoryIds);
        return new ServerBoundBusinessRegistrationRequestPacket(registrationRequest);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            BusinessService service = Services.getService(BusinessService.class);
            Response r = service.registerBusiness((OnlinePlayer)p, this.registrationRequest);
            p.showResponse(r);
        });
    }
}

