/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.business.BusinessService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundBusinessSearchPageRequestPacket {
    private final UUID requestId;
    private final int pageNumber;
    private final String searchTerms;

    public ServerBoundBusinessSearchPageRequestPacket(UUID requestId, int pageNumber, String searchTerms) {
        this.requestId = requestId;
        this.pageNumber = pageNumber;
        this.searchTerms = searchTerms;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.requestId);
        buffer.writeInt(this.pageNumber);
        buffer.m_130070_(this.searchTerms);
    }

    public static ServerBoundBusinessSearchPageRequestPacket decode(FriendlyByteBuf buffer) {
        UUID requestId = buffer.m_130259_();
        int pageNumber = buffer.readInt();
        String searchTerms = buffer.m_130277_();
        return new ServerBoundBusinessSearchPageRequestPacket(requestId, pageNumber, searchTerms);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            BusinessService service = Services.getService(BusinessService.class);
            service.showBusinessSelectPage((OnlinePlayer)p, this.requestId, this.pageNumber, this.searchTerms);
        });
    }
}

