/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.business.BusinessSelectAction;
import com.equestricraft.mod.business.BusinessService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundBusinessSelectPacket {
    private final int businessId;
    private final BusinessSelectAction businessSelectAction;

    public ServerBoundBusinessSelectPacket(int businessId, BusinessSelectAction businessSelectAction) {
        this.businessId = businessId;
        this.businessSelectAction = businessSelectAction;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.businessId);
        buffer.m_130068_((Enum)this.businessSelectAction);
    }

    public static ServerBoundBusinessSelectPacket decode(FriendlyByteBuf buffer) {
        int businessId = buffer.readInt();
        BusinessSelectAction businessSelectAction = (BusinessSelectAction)buffer.m_130066_(BusinessSelectAction.class);
        return new ServerBoundBusinessSelectPacket(businessId, businessSelectAction);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            BusinessService businessService = Services.getService(BusinessService.class);
            businessService.processBusinessListMenuSelect((OnlinePlayer)p, this.businessId, this.businessSelectAction);
        });
    }
}

