/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.mod.horse.HorseRespondToCallAction;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundCallHorseRequestPacket {
    private final int horseId;

    public ServerBoundCallHorseRequestPacket(int horseId) {
        this.horseId = horseId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
    }

    public static ServerBoundCallHorseRequestPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        return new ServerBoundCallHorseRequestPacket(horseId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseRepository horseRepository = Services.getService(HorseRepository.class);
            EQHorse horse = (EQHorse)horseRepository.findByKey(this.horseId);
            horse.getActions().processAction(new HorseRespondToCallAction(horse, (OnlinePlayer)p));
        });
    }
}

