/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.chattag.ChatTagService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundChatTagSetPacket {
    private final int tagId;
    private final boolean set;

    public ServerBoundChatTagSetPacket(int tagId, boolean set2) {
        this.tagId = tagId;
        this.set = set2;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.tagId);
        buffer.writeBoolean(this.set);
    }

    public static ServerBoundChatTagSetPacket decode(FriendlyByteBuf buffer) {
        int tagId = buffer.readInt();
        boolean set2 = buffer.readBoolean();
        return new ServerBoundChatTagSetPacket(tagId, set2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ChatTagService service = Services.getService(ChatTagService.class);
            Response r = this.set ? service.setActiveChatTag((ECPlayer)p, this.tagId) : service.removeChatTag((ECPlayer)p);
            p.showResponse(r);
        });
    }
}

