/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.club.ClubService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundClubAcceptJoinRequestPacket {
    private final int playerId;

    public ServerBoundClubAcceptJoinRequestPacket(int playerId) {
        this.playerId = playerId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.playerId);
    }

    public static ServerBoundClubAcceptJoinRequestPacket decode(FriendlyByteBuf buffer) {
        int requestId = buffer.readInt();
        return new ServerBoundClubAcceptJoinRequestPacket(requestId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ClubService service = Services.getService(ClubService.class);
            Response r = service.approveJoinRequest((OnlinePlayer)p, this.playerId);
            p.showResponse(r);
        });
    }
}

