/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.club.ClubService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundClubMemberPageOpenPacket {
    private final int clubId;
    private final int pageNumber;

    public ServerBoundClubMemberPageOpenPacket(int clubId, int pageNumber) {
        this.clubId = clubId;
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.clubId);
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundClubMemberPageOpenPacket decode(FriendlyByteBuf buffer) {
        int clubId = buffer.readInt();
        int pageNumber = buffer.readInt();
        return new ServerBoundClubMemberPageOpenPacket(clubId, pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ClubService service = Services.getService(ClubService.class);
            service.showClubMembersMenu((OnlinePlayer)p, this.clubId, this.pageNumber);
        });
    }
}

