/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.club.ClubService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundClubRankEditLevelPacket {
    private final int rankId;

    public ServerBoundClubRankEditLevelPacket(int rankId) {
        this.rankId = rankId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.rankId);
    }

    public static ServerBoundClubRankEditLevelPacket decode(FriendlyByteBuf buffer) {
        int rankId = buffer.readInt();
        return new ServerBoundClubRankEditLevelPacket(rankId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ClubService service = Services.getService(ClubService.class);
            Response r = service.changeRanksPermissionLevel((OnlinePlayer)p, this.rankId);
            p.showResponse(r);
        });
    }
}

