/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.club.ClubService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundClubSendJoinRequestPacket {
    private final int clubId;

    public ServerBoundClubSendJoinRequestPacket(int clubId) {
        this.clubId = clubId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.clubId);
    }

    public static ServerBoundClubSendJoinRequestPacket decode(FriendlyByteBuf buffer) {
        int clubId = buffer.readInt();
        return new ServerBoundClubSendJoinRequestPacket(clubId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ClubService service = Services.getService(ClubService.class);
            Response r = service.sendJoinRequest((OnlinePlayer)p, this.clubId);
            p.showResponse(r);
        });
    }
}

