/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.club.ClubService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundClubSetAllowJoinRequestsPacket {
    private final boolean allow;

    public ServerBoundClubSetAllowJoinRequestsPacket(boolean allow) {
        this.allow = allow;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.allow);
    }

    public static ServerBoundClubSetAllowJoinRequestsPacket decode(FriendlyByteBuf buffer) {
        boolean allow = buffer.readBoolean();
        return new ServerBoundClubSetAllowJoinRequestsPacket(allow);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ClubService service = Services.getService(ClubService.class);
            Response r = service.setAllowJoinRequests((OnlinePlayer)p, this.allow);
            p.showResponse(r);
        });
    }
}

