/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.registration.HorseRegistrationService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundConfirmHorseRegistrationPacket {
    private final int horseId;
    private final int organizationId;
    private final String showName;

    public ServerBoundConfirmHorseRegistrationPacket(int horseId, int organizationId, String showName) {
        this.horseId = horseId;
        this.organizationId = organizationId;
        this.showName = showName;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.organizationId);
        buffer.m_130070_(this.showName);
    }

    public static ServerBoundConfirmHorseRegistrationPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int organizationId = buffer.readInt();
        String showName = buffer.m_130277_();
        return new ServerBoundConfirmHorseRegistrationPacket(horseId, organizationId, showName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseRegistrationService service = Services.getService(HorseRegistrationService.class);
            Response r = service.registerHorse((OnlinePlayer)p, this.horseId, this.organizationId, this.showName);
            p.showResponse(r);
        });
    }
}

