/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.job.requests.JobRequestService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundCreateJobRequestPacket {
    private final int jobId;
    private final String description;

    public ServerBoundCreateJobRequestPacket(int jobId, String description) {
        this.jobId = jobId;
        this.description = description;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.jobId);
        buffer.m_130070_(this.description);
    }

    public static ServerBoundCreateJobRequestPacket decode(FriendlyByteBuf buffer) {
        int jobId = buffer.readInt();
        String description = buffer.m_130277_();
        return new ServerBoundCreateJobRequestPacket(jobId, description);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            JobRequestService service = Services.getService(JobRequestService.class);
            Response r = service.sendJobRequest((OnlinePlayer)p, this.jobId, this.description);
            p.showResponse(r);
        });
    }
}

