/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.HorseCoatModifiers;
import com.equestricraft.common.HorseGender;
import com.equestricraft.mod.horse.create.HorseCreateMenuService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundCustomHorseCreatePacket {
    private final String name;
    private final HorseGender gender;
    private final int ageMonths;
    private final HorseCoatColor color;
    private final HorseCoatModifiers modifiers;
    private final int breedId;
    private final double height;

    public ServerBoundCustomHorseCreatePacket(String name, HorseGender gender, int ageMonths, HorseCoatColor color, HorseCoatModifiers modifiers, int breedId, double height) {
        this.name = name;
        this.gender = gender;
        this.ageMonths = ageMonths;
        this.color = color;
        this.modifiers = modifiers;
        this.breedId = breedId;
        this.height = height;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.m_130068_((Enum)this.gender);
        buffer.writeInt(this.ageMonths);
        buffer.m_130068_((Enum)this.color);
        buffer.writeBoolean(this.modifiers.isGray());
        buffer.writeInt(this.modifiers.getMarkingSelections().size());
        for (HorseCoatMarking marking : this.modifiers.getMarkingSelections()) {
            buffer.m_130068_((Enum)marking);
        }
        buffer.writeInt(this.breedId);
        buffer.writeDouble(this.height);
    }

    public static ServerBoundCustomHorseCreatePacket decode(FriendlyByteBuf buffer) {
        String name = buffer.m_130277_();
        HorseGender gender = (HorseGender)buffer.m_130066_(HorseGender.class);
        int ageMonths = buffer.readInt();
        HorseCoatColor color = (HorseCoatColor)buffer.m_130066_(HorseCoatColor.class);
        boolean gray = buffer.readBoolean();
        int markingsCount = buffer.readInt();
        ArrayList<HorseCoatMarking> markings = new ArrayList<HorseCoatMarking>(markingsCount);
        for (int i = 0; i < markingsCount; ++i) {
            markings.add((HorseCoatMarking)buffer.m_130066_(HorseCoatMarking.class));
        }
        HorseCoatModifiers modifiers = new HorseCoatModifiers(gray, markings);
        int breedId = buffer.readInt();
        double height = buffer.readDouble();
        return new ServerBoundCustomHorseCreatePacket(name, gender, ageMonths, color, modifiers, breedId, height);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseCreateMenuService service = Services.getService(HorseCreateMenuService.class);
            Response response = service.processHorseCreateMenuCreate((OnlinePlayer)p, this.name, this.gender, this.ageMonths, this.color, this.modifiers, this.breedId, this.height);
            p.showResponse(response);
        });
    }
}

