/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundDeadHorseSelectPacket {
    private final UUID uuid;
    private final Integer horseId;

    public ServerBoundDeadHorseSelectPacket(UUID uuid, Integer horseId) {
        this.uuid = uuid;
        this.horseId = horseId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        if (this.horseId != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.horseId.intValue());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ServerBoundDeadHorseSelectPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        Integer horseId = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        return new ServerBoundDeadHorseSelectPacket(uuid, horseId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseRepository horseRepository = Services.getService(HorseRepository.class);
            EQHorse horse = this.horseId != null ? (EQHorse)horseRepository.findByKey(this.horseId) : null;
            PromptResponsesHandler.getInstance().provideResponse((ECPlayer)p, this.uuid, horse);
        });
    }
}

