/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.fasttravel.FastTravelService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundFastTravelPacket {
    private final int pointId;

    public ServerBoundFastTravelPacket(int pointId) {
        this.pointId = pointId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pointId);
    }

    public static ServerBoundFastTravelPacket decode(FriendlyByteBuf buffer) {
        int pointId = buffer.readInt();
        return new ServerBoundFastTravelPacket(pointId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            FastTravelService service = Services.getService(FastTravelService.class);
            Response response = service.performFastTravel((OnlinePlayer)p, this.pointId);
            p.showResponse(response);
        });
    }
}

