/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.FeedbackType;
import com.equestricraft.mod.feedback.FeedbackService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundFeedbackSubmitPacket {
    private final String title;
    private final String message;
    private final FeedbackType type;

    public ServerBoundFeedbackSubmitPacket(String title, String message, FeedbackType type) {
        this.title = title;
        this.message = message;
        this.type = type;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.title);
        buffer.m_130070_(this.message);
        buffer.m_130068_((Enum)this.type);
    }

    public static ServerBoundFeedbackSubmitPacket decode(FriendlyByteBuf buffer) {
        String title = buffer.m_130277_();
        String message = buffer.m_130277_();
        FeedbackType type = (FeedbackType)buffer.m_130066_(FeedbackType.class);
        return new ServerBoundFeedbackSubmitPacket(title, message, type);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            FeedbackService service = Services.getService(FeedbackService.class);
            Response r = service.submitFeedback((OnlinePlayer)p, this.title, this.message, this.type);
            p.showResponse(r);
        });
    }
}

