/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.speed.HorseSpeedService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundGallopCancelPacket {
    private final UUID horseUuid;

    public ServerBoundGallopCancelPacket(UUID horseUuid) {
        this.horseUuid = horseUuid;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.horseUuid);
    }

    public static ServerBoundGallopCancelPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        return new ServerBoundGallopCancelPacket(uuid);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            Entity patt1164$temp = p.serverPlayer().m_183503_().m_8791_(this.horseUuid);
            if (!(patt1164$temp instanceof EntityHorse)) {
                throw new IllegalArgumentException(String.format("Supplied invalid horse UUID: %s", this.horseUuid));
            }
            EntityHorse horse = (EntityHorse)patt1164$temp;
            HorseSpeedService service = Services.getService(HorseSpeedService.class);
            service.cancelGallop(horse, (OnlinePlayer)p);
        });
    }
}

