/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.provision.ProvisionService;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundGiveProvisionToHorsePacket {
    private final UUID provisionUuid;
    private final int horseId;

    public ServerBoundGiveProvisionToHorsePacket(UUID provisionUuid, int horseId) {
        this.provisionUuid = provisionUuid;
        this.horseId = horseId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.provisionUuid);
        buffer.writeInt(this.horseId);
    }

    public static ServerBoundGiveProvisionToHorsePacket decode(FriendlyByteBuf buffer) {
        UUID provisionUuid = buffer.m_130259_();
        int horseId = buffer.readInt();
        return new ServerBoundGiveProvisionToHorsePacket(provisionUuid, horseId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ProvisionService service = Services.getService(ProvisionService.class);
            Response r = service.giveProvisionToHorse((OnlinePlayer)p, this.provisionUuid, this.horseId);
            p.showResponse(r);
        });
    }
}

