/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.horse.access.HorseAccessService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseAccessAddPlayerPacket {
    private final int horseId;

    public ServerBoundHorseAccessAddPlayerPacket(int horseId) {
        this.horseId = horseId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
    }

    public static ServerBoundHorseAccessAddPlayerPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        return new ServerBoundHorseAccessAddPlayerPacket(horseId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseAccessService service = Services.getService(HorseAccessService.class);
            Response r = service.startPlayerHorseAccessGrant((ECPlayer)p, this.horseId);
            p.showResponse(r);
        });
    }
}

