/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.horse.access.HorseAccessService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseAccessRemovePlayerPacket {
    private final int horseId;
    private final int playerId;

    public ServerBoundHorseAccessRemovePlayerPacket(int horseId, int playerId) {
        this.horseId = horseId;
        this.playerId = playerId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.playerId);
    }

    public static ServerBoundHorseAccessRemovePlayerPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int playerId = buffer.readInt();
        return new ServerBoundHorseAccessRemovePlayerPacket(horseId, playerId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseAccessService service = Services.getService(HorseAccessService.class);
            Response r = service.revokeAccessFromHorse((ECPlayer)p, this.horseId, this.playerId);
            p.showResponse(r);
        });
    }
}

