/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.speed.HorseSpeedService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseChangeGaitPacket {
    private final UUID horseUuid;
    private final boolean increase;

    public ServerBoundHorseChangeGaitPacket(UUID horseUuid, boolean increase) {
        this.horseUuid = horseUuid;
        this.increase = increase;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.horseUuid);
        buffer.writeBoolean(this.increase);
    }

    public static ServerBoundHorseChangeGaitPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        boolean action = buffer.readBoolean();
        return new ServerBoundHorseChangeGaitPacket(uuid, action);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            Entity patt1632$temp = p.serverPlayer().m_183503_().m_8791_(this.horseUuid);
            if (patt1632$temp instanceof EntityHorse) {
                EntityHorse horse = (EntityHorse)patt1632$temp;
                HorseSpeedService service = Services.getService(HorseSpeedService.class);
                if (this.increase) {
                    service.processGaitIncreaseInput(horse, (OnlinePlayer)p);
                } else {
                    service.decrementHorseGait(horse, (OnlinePlayer)p);
                }
            } else {
                throw new IllegalArgumentException(String.format("Supplied invalid horse UUID: %s", this.horseUuid));
            }
        });
    }
}

