/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.speed.HorseSpeedService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseChangeGaitSpeedPacket {
    private final UUID horseUuid;
    private final boolean increase;

    public ServerBoundHorseChangeGaitSpeedPacket(UUID horseUuid, boolean increase) {
        this.horseUuid = horseUuid;
        this.increase = increase;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.horseUuid);
        buffer.writeBoolean(this.increase);
    }

    public static ServerBoundHorseChangeGaitSpeedPacket decode(FriendlyByteBuf buffer) {
        UUID horseUuid = buffer.m_130259_();
        boolean increase = buffer.readBoolean();
        return new ServerBoundHorseChangeGaitSpeedPacket(horseUuid, increase);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            Entity patt1428$temp = p.serverPlayer().m_183503_().m_8791_(this.horseUuid);
            if (patt1428$temp instanceof EntityHorse) {
                EntityHorse horse = (EntityHorse)patt1428$temp;
                HorseSpeedService service = Services.getService(HorseSpeedService.class);
                if (this.increase) {
                    service.setHigherGaitSpeed(horse, (OnlinePlayer)p);
                } else {
                    service.setLowerGaitSpeed(horse, (OnlinePlayer)p);
                }
            } else {
                throw new IllegalArgumentException(String.format("Supplier invalid horse UUID: %s", this.horseUuid));
            }
        });
    }
}

