/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.HorseCoatColor;
import com.equestricraft.common.HorseCoatMarking;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.genetic.NumericalGeneticValue;
import com.equestricraft.core.horse.coat.HorseCoatDetails;
import com.equestricraft.core.horse.create.HorseCreateBreedRequest;
import com.equestricraft.mod.horse.create.HorseCreateMenuService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseCreateBreedRequestPacket {
    private final HorseCreateBreedRequest horseCreateBreedRequest;

    public ServerBoundHorseCreateBreedRequestPacket(HorseCreateBreedRequest horseCreateBreedRequest) {
        this.horseCreateBreedRequest = horseCreateBreedRequest;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(((Number)this.horseCreateBreedRequest.getBaseHeight().getLowerValue()).doubleValue());
        buffer.writeDouble(((Number)this.horseCreateBreedRequest.getBaseHeight().getUpperValue()).doubleValue());
        buffer.m_130068_((Enum)this.horseCreateBreedRequest.getCoatDetails().getColor());
        buffer.writeInt(this.horseCreateBreedRequest.getCoatDetails().getMarkings().size());
        for (HorseCoatMarking marking : this.horseCreateBreedRequest.getCoatDetails().getMarkings()) {
            buffer.m_130068_((Enum)marking);
        }
        buffer.writeFloat(this.horseCreateBreedRequest.getCoatDetails().getGrayScale());
        buffer.writeDouble(((Number)this.horseCreateBreedRequest.getBaseWeight().getLowerValue()).doubleValue());
        buffer.writeDouble(((Number)this.horseCreateBreedRequest.getBaseWeight().getUpperValue()).doubleValue());
        buffer.m_130068_((Enum)this.horseCreateBreedRequest.getHorseGender());
    }

    public static ServerBoundHorseCreateBreedRequestPacket decode(FriendlyByteBuf buffer) {
        double heightLowerValue = buffer.readDouble();
        double heightUpperValue = buffer.readDouble();
        NumericalGeneticValue baseHeight = new NumericalGeneticValue(heightLowerValue, heightUpperValue);
        HorseCoatColor coatColor = (HorseCoatColor)buffer.m_130066_(HorseCoatColor.class);
        int markingsCount = buffer.readInt();
        ArrayList<HorseCoatMarking> markings = new ArrayList<HorseCoatMarking>(markingsCount);
        for (int i = 0; i < markingsCount; ++i) {
            HorseCoatMarking marking = (HorseCoatMarking)buffer.m_130066_(HorseCoatMarking.class);
            markings.add(marking);
        }
        float greyScale = buffer.readFloat();
        HorseCoatDetails coatDetails = HorseCoatDetails.Builder.start().withColor(coatColor).withMarkings(markings).withGrayScale(greyScale).complete();
        double weightLowerValue = buffer.readDouble();
        double weightUpperValue = buffer.readDouble();
        NumericalGeneticValue weight = new NumericalGeneticValue(weightLowerValue, weightUpperValue);
        HorseGender gender = (HorseGender)buffer.m_130066_(HorseGender.class);
        HorseCreateBreedRequest request = new HorseCreateBreedRequest(coatDetails, baseHeight, weight, gender);
        return new ServerBoundHorseCreateBreedRequestPacket(request);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseCreateMenuService service = Services.getService(HorseCreateMenuService.class);
            Response r = service.requestValidBreedUpdates((OnlinePlayer)p, this.horseCreateBreedRequest);
            p.showResponse(r);
        });
    }
}

