/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.core.horse.instruction.HorseInstructionType;
import com.equestricraft.mod.horse.instruction.HorseInstructionHandler;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseInstructionGivePacket {
    private final UUID horseEntityUuid;
    private final HorseInstructionType instructionType;
    private final boolean action;

    public ServerBoundHorseInstructionGivePacket(UUID horseEntityUuid, HorseInstructionType instructionType, boolean action) {
        this.horseEntityUuid = horseEntityUuid;
        this.instructionType = instructionType;
        this.action = action;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.horseEntityUuid);
        buffer.m_130068_((Enum)this.instructionType);
        buffer.writeBoolean(this.action);
    }

    public static ServerBoundHorseInstructionGivePacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        HorseInstructionType type = (HorseInstructionType)buffer.m_130066_(HorseInstructionType.class);
        boolean action = buffer.readBoolean();
        return new ServerBoundHorseInstructionGivePacket(uuid, type, action);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseInstructionHandler handler = HorseInstructionHandler.getInstance();
            Response r = handler.handleInstruction((OnlinePlayer)p, this.horseEntityUuid, this.instructionType, this.action);
            p.showResponse(r);
        });
    }
}

