/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.mod.horse.interact.HorseInteractAction;
import com.equestricraft.mod.horse.interact.HorseInteractActionHandler;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseInteractMenuSelectPacket {
    private final UUID entityUuid;
    private final HorseInteractAction action;

    public ServerBoundHorseInteractMenuSelectPacket(UUID entityUuid, HorseInteractAction action) {
        this.entityUuid = entityUuid;
        this.action = action;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.entityUuid);
        buffer.m_130068_((Enum)this.action);
    }

    public static ServerBoundHorseInteractMenuSelectPacket decode(FriendlyByteBuf buffer) {
        UUID entityUuid = buffer.m_130259_();
        HorseInteractAction action = (HorseInteractAction)buffer.m_130066_(HorseInteractAction.class);
        return new ServerBoundHorseInteractMenuSelectPacket(entityUuid, action);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseInteractActionHandler horseInteractionHandler = HorseInteractActionHandler.getInstance();
            Response r = horseInteractionHandler.handleInteraction((OnlinePlayer)p, this.entityUuid, this.action);
            p.showResponse(r);
        });
    }
}

