/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.list.HorseListSortOrder;
import com.equestricraft.mod.horse.list.HorseListService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseListRefreshPacket {
    private final int pageNumber;
    private final HorseListSortOrder sortOrder;
    private final SortDirection sortDirection;
    private final String textSearch;

    public ServerBoundHorseListRefreshPacket(int pageNumber, HorseListSortOrder sortOrder, SortDirection sortDirection, String textSearch) {
        this.pageNumber = pageNumber;
        this.sortOrder = sortOrder;
        this.sortDirection = sortDirection;
        this.textSearch = textSearch;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pageNumber);
        buffer.m_130068_((Enum)this.sortOrder);
        buffer.m_130068_((Enum)this.sortDirection);
        buffer.m_130070_(this.textSearch);
    }

    public static ServerBoundHorseListRefreshPacket decode(FriendlyByteBuf buffer) {
        int pageNumber = buffer.readInt();
        HorseListSortOrder sortOrder = (HorseListSortOrder)buffer.m_130066_(HorseListSortOrder.class);
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        String textSearch = buffer.m_130277_();
        return new ServerBoundHorseListRefreshPacket(pageNumber, sortOrder, sortDirection, textSearch);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseListService service = Services.getService(HorseListService.class);
            service.showHorseListToPlayer((OnlinePlayer)p, this.sortOrder, this.sortDirection, this.pageNumber, this.textSearch);
        });
    }
}

