/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.horse.list.HorseListService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseListSelectPacket {
    private final int horseId;

    public ServerBoundHorseListSelectPacket(int horseId) {
        this.horseId = horseId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
    }

    public static ServerBoundHorseListSelectPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        return new ServerBoundHorseListSelectPacket(horseId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseListService service = Services.getService(HorseListService.class);
            service.onHorseMenuSelect((OnlinePlayer)p, this.horseId);
        });
    }
}

