/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.horse.access.HorseAccessService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorsePlayerAccessListShowPacket {
    private final int horseId;
    private final int pageNumber;

    public ServerBoundHorsePlayerAccessListShowPacket(int horseId, int pageNumber) {
        this.horseId = horseId;
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundHorsePlayerAccessListShowPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int pageNumber = buffer.readInt();
        return new ServerBoundHorsePlayerAccessListShowPacket(horseId, pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseAccessService service = Services.getService(HorseAccessService.class);
            Response response = service.showHorseAccessMenu((ECPlayer)p, this.horseId, this.pageNumber);
            p.showResponse(response);
        });
    }
}

