/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.common.tack.TackType;
import com.equestricraft.core.horse.tack.HorseTackService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseRemoveTackPacket {
    private final int horseId;
    private final TackType type;

    public ServerBoundHorseRemoveTackPacket(int horseId, TackType type) {
        this.horseId = horseId;
        this.type = type;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.m_130068_((Enum)this.type);
    }

    public static ServerBoundHorseRemoveTackPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        TackType type = (TackType)buffer.m_130066_(TackType.class);
        return new ServerBoundHorseRemoveTackPacket(horseId, type);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseTackService service = Services.getService(HorseTackService.class);
            service.removeTackFromHorse(this.horseId, this.type);
        });
    }
}

