/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.horse.sell.HorseSellService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseSellMenuResponse {
    private final int horseId;
    private final boolean confirm;
    private final String newName;

    public ServerBoundHorseSellMenuResponse(int horseId, boolean confirm, String newName) {
        this.horseId = horseId;
        this.confirm = confirm;
        this.newName = newName;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeBoolean(this.confirm);
        if (this.confirm) {
            buffer.m_130070_(this.newName);
        }
    }

    public static ServerBoundHorseSellMenuResponse decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        boolean confirm = buffer.readBoolean();
        String newName = confirm ? buffer.m_130277_() : null;
        return new ServerBoundHorseSellMenuResponse(horseId, confirm, newName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseSellService service = Services.getService(HorseSellService.class);
            Response response = this.confirm ? service.confirmHorseSell((OnlinePlayer)p, this.horseId, this.newName) : service.cancelSelling((OnlinePlayer)p, this.horseId);
            p.showResponse(response);
        });
    }
}

