/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.gait.Gait;
import com.equestricraft.core.horse.gait.HorseGaitCache;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.speed.HorseSpeedService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundHorseSetSpeedPacket {
    private final UUID horseUuid;
    private final Gait gait;

    public ServerBoundHorseSetSpeedPacket(UUID horseUuid, Gait gait) {
        this.horseUuid = horseUuid;
        this.gait = gait;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.horseUuid);
        buffer.m_130068_((Enum)this.gait);
    }

    public static ServerBoundHorseSetSpeedPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        Gait gait = (Gait)buffer.m_130066_(Gait.class);
        return new ServerBoundHorseSetSpeedPacket(uuid, gait);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            Entity entity = p.serverPlayer().m_183503_().m_8791_(this.horseUuid);
            if (!(entity instanceof EntityHorse)) {
                throw new IllegalArgumentException(String.format("Supplied invalid horse UUID: %s, given entity was %s", this.horseUuid, entity == null ? "null" : entity.getClass().getName()));
            }
            EntityHorse horse = (EntityHorse)entity;
            HorseSpeedService service = Services.getService(HorseSpeedService.class);
            HorseGaitCache gaitLookup = HorseGaitCache.getInstance();
            HorseSubGait g = gaitLookup.findByGaitType(this.gait);
            service.setHorseSpeed(horse, g);
        });
    }
}

