/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.job.JobMembersScreenService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundJobMemberMenuRefreshPacket {
    private final int jobId;
    private final int pageNumber;

    public ServerBoundJobMemberMenuRefreshPacket(int jobId, int pageNumber) {
        this.jobId = jobId;
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.jobId);
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundJobMemberMenuRefreshPacket decode(FriendlyByteBuf buffer) {
        int jobId = buffer.readInt();
        int pageNumber = buffer.readInt();
        return new ServerBoundJobMemberMenuRefreshPacket(jobId, pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            JobMembersScreenService service = Services.getService(JobMembersScreenService.class);
            service.showJobMembersMenu((OnlinePlayer)p, this.jobId, this.pageNumber);
        });
    }
}

