/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.job.requests.JobRequestService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundJobRequestCompletePacket {
    private final int requestId;

    public ServerBoundJobRequestCompletePacket(int requestId) {
        this.requestId = requestId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.requestId);
    }

    public static ServerBoundJobRequestCompletePacket decode(FriendlyByteBuf buffer) {
        int requestId = buffer.readInt();
        return new ServerBoundJobRequestCompletePacket(requestId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            JobRequestService service = Services.getService(JobRequestService.class);
            Response r = service.completeJobRequest((OnlinePlayer)p, this.requestId);
            p.showResponse(r);
        });
    }
}

