/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.job.requests.JobRequestService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundJobRequestsMenuOpenPacket {
    private final int jobId;
    private final int pageNumber;

    public ServerBoundJobRequestsMenuOpenPacket(int jobId, int pageNumber) {
        this.jobId = jobId;
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.jobId);
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundJobRequestsMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int jobId = buffer.readInt();
        int pageNumber = buffer.readInt();
        return new ServerBoundJobRequestsMenuOpenPacket(jobId, pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            JobRequestService service = Services.getService(JobRequestService.class);
            service.showJobRequestPageToPlayer((OnlinePlayer)p, this.jobId, this.pageNumber);
        });
    }
}

