/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.job.activework.JobActiveWorkService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundJobStartWorkPacket {
    private final int forPlayerId;
    private final String title;
    private final String description;
    private final double estimatedPrice;

    public ServerBoundJobStartWorkPacket(int forPlayerId, String title, String description, double estimatedPrice) {
        this.forPlayerId = forPlayerId;
        this.title = title;
        this.description = description;
        this.estimatedPrice = estimatedPrice;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.forPlayerId);
        buffer.m_130070_(this.title);
        buffer.m_130070_(this.description);
        buffer.writeDouble(this.estimatedPrice);
    }

    public static ServerBoundJobStartWorkPacket decode(FriendlyByteBuf buffer) {
        int forPlayerId = buffer.readInt();
        String title = buffer.m_130277_();
        String description = buffer.m_130277_();
        double estimatedPrice = buffer.readDouble();
        return new ServerBoundJobStartWorkPacket(forPlayerId, title, description, estimatedPrice);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            JobActiveWorkService service = Services.getService(JobActiveWorkService.class);
            Response r = service.startWork((OnlinePlayer)p, this.forPlayerId, this.title, this.description, this.estimatedPrice);
            p.showResponse(r);
        });
    }
}

