/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.leaderboard.LeaderboardService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundLeaderboardOpenPacket {
    private final int leaderboardId;

    public ServerBoundLeaderboardOpenPacket(int leaderboardId) {
        this.leaderboardId = leaderboardId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.leaderboardId);
    }

    public static ServerBoundLeaderboardOpenPacket decode(FriendlyByteBuf buffer) {
        int leaderboardId = buffer.readInt();
        return new ServerBoundLeaderboardOpenPacket(leaderboardId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            LeaderboardService service = Services.getService(LeaderboardService.class);
            service.showLeaderboard((OnlinePlayer)p, this.leaderboardId);
        });
    }
}

