/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.horse.HorseService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundLineageMenuOpenPacket {
    private final int horseId;

    public ServerBoundLineageMenuOpenPacket(int horseId) {
        this.horseId = horseId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
    }

    public static ServerBoundLineageMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        return new ServerBoundLineageMenuOpenPacket(horseId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            HorseService service = Services.getService(HorseService.class);
            service.showLinageMenu((OnlinePlayer)p, this.horseId);
        });
    }
}

