/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.medicine.MedicineService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundMedicineInventoryItemSelectPacket {
    private final int horseId;
    private final int medicineId;

    public ServerBoundMedicineInventoryItemSelectPacket(int horseId, int medicineId) {
        this.horseId = horseId;
        this.medicineId = medicineId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.medicineId);
    }

    public static ServerBoundMedicineInventoryItemSelectPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int medicineId = buffer.readInt();
        return new ServerBoundMedicineInventoryItemSelectPacket(horseId, medicineId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            MedicineService service = Services.getService(MedicineService.class);
            Response r = service.giveMedicineToHorse((OnlinePlayer)p, this.medicineId, this.horseId);
            p.showResponse(r);
        });
    }
}

