/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundMultiSelectOptionPromptResponsePacket {
    private final UUID uuid;
    private final List<Integer> selectionIds;

    public ServerBoundMultiSelectOptionPromptResponsePacket(UUID uuid, List<Integer> selectionIds) {
        this.uuid = uuid;
        this.selectionIds = selectionIds;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        if (this.selectionIds == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeInt(this.selectionIds.size());
            for (Integer id : this.selectionIds) {
                buffer.writeInt(id.intValue());
            }
        }
    }

    public static ServerBoundMultiSelectOptionPromptResponsePacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        boolean hasList = buffer.readBoolean();
        if (hasList) {
            int size = buffer.readInt();
            ArrayList<Integer> selectionIds = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                selectionIds.add(buffer.readInt());
            }
            return new ServerBoundMultiSelectOptionPromptResponsePacket(uuid, selectionIds);
        }
        return new ServerBoundMultiSelectOptionPromptResponsePacket(uuid, null);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> PromptResponsesHandler.getInstance().provideResponse((ECPlayer)p, this.uuid, this.selectionIds));
    }
}

