/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.ClickType;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.npc.NPCService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundNPCInteractEventPacket {
    private final int npcId;
    private final ClickType clickType;

    public ServerBoundNPCInteractEventPacket(int npcId, ClickType clickType) {
        this.npcId = npcId;
        this.clickType = clickType;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.npcId);
        buffer.m_130068_((Enum)this.clickType);
    }

    public static ServerBoundNPCInteractEventPacket decode(FriendlyByteBuf buffer) {
        int npcId = buffer.readInt();
        ClickType clickType = (ClickType)buffer.m_130066_(ClickType.class);
        return new ServerBoundNPCInteractEventPacket(npcId, clickType);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            NPCService npcService = Services.getService(NPCService.class);
            npcService.npcInteracted((OnlinePlayer)p, this.npcId, this.clickType);
        });
    }
}

