/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.nickname.NicknameChangeRequest;
import com.equestricraft.mod.nickname.NicknameSerializer;
import com.equestricraft.mod.nickname.NicknameService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundNicknameChangePacket {
    private final NicknameChangeRequest request;

    public ServerBoundNicknameChangePacket(NicknameChangeRequest request) {
        this.request = request;
    }

    public void encode(FriendlyByteBuf buffer) {
        NicknameSerializer.serializeNicknameChangeRequest(this.request, buffer);
    }

    public static ServerBoundNicknameChangePacket decode(FriendlyByteBuf buffer) {
        NicknameChangeRequest request = NicknameSerializer.deserializeNicknameChangeRequest(buffer);
        return new ServerBoundNicknameChangePacket(request);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            NicknameService service = Services.getService(NicknameService.class);
            Response r = service.changeNicknameWithCharge((OnlinePlayer)p, this.request);
            p.showResponse(r);
        });
    }
}

