/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.operation.OperationService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundOperationSelectPacket {
    private final int operationId;

    public ServerBoundOperationSelectPacket(int operationId) {
        this.operationId = operationId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.operationId);
    }

    public static ServerBoundOperationSelectPacket decode(FriendlyByteBuf buffer) {
        int operationId = buffer.readInt();
        return new ServerBoundOperationSelectPacket(operationId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            OperationService service = Services.getService(OperationService.class);
            Response r = service.giveToolToPlayer(p.serverPlayer(), this.operationId);
            p.showResponse(r);
        });
    }
}

