/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.job.activework.JobActiveWorkService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPayInvoicePacket {
    private final int invoiceId;

    public ServerBoundPayInvoicePacket(int invoiceId) {
        this.invoiceId = invoiceId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.invoiceId);
    }

    public static ServerBoundPayInvoicePacket decode(FriendlyByteBuf buffer) {
        int invoiceId = buffer.readInt();
        return new ServerBoundPayInvoicePacket(invoiceId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            JobActiveWorkService service = Services.getService(JobActiveWorkService.class);
            Response r = service.payInvoice((OnlinePlayer)p, this.invoiceId);
            p.showResponse(r);
        });
    }
}

