/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.approval.PendingApprovalService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPendingApprovalResponsePacket {
    private final UUID uuid;
    private final boolean approved;

    public ServerBoundPendingApprovalResponsePacket(UUID uuid, boolean approved) {
        this.uuid = uuid;
        this.approved = approved;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.writeBoolean(this.approved);
    }

    public static ServerBoundPendingApprovalResponsePacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        boolean approved = buffer.readBoolean();
        return new ServerBoundPendingApprovalResponsePacket(uuid, approved);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PendingApprovalService service = Services.getService(PendingApprovalService.class);
            Response r = this.approved ? service.approve((OnlinePlayer)p, this.uuid) : service.deny((OnlinePlayer)p, this.uuid);
            p.showResponse(r);
        });
    }
}

