/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.player.inventory.ModPlayerInventoryService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlayerInventoryScreenRefreshPacket {
    private final int pageNumber;

    public ServerBoundPlayerInventoryScreenRefreshPacket(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundPlayerInventoryScreenRefreshPacket decode(FriendlyByteBuf buffer) {
        int pageNumber = buffer.readInt();
        return new ServerBoundPlayerInventoryScreenRefreshPacket(pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ModPlayerInventoryService service = Services.getService(ModPlayerInventoryService.class);
            service.showInventoryToPlayer((OnlinePlayer)p, this.pageNumber);
        });
    }
}

