/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.job.activework.JobActiveWorkService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlayerInvoiceListOpenPacket {
    private final int pageNumber;

    public ServerBoundPlayerInvoiceListOpenPacket(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundPlayerInvoiceListOpenPacket decode(FriendlyByteBuf buffer) {
        int pageNumber = buffer.readInt();
        return new ServerBoundPlayerInvoiceListOpenPacket(pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            JobActiveWorkService service = Services.getService(JobActiveWorkService.class);
            service.showPlayersDueInvoices((OnlinePlayer)p, this.pageNumber);
        });
    }
}

