/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.notification.ModPlayerNotificationService;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlayerNotificationMenuOpenRequestPacket {
    private final int pageNumber;
    private final SortDirection sortDirection;
    private final String textSearch;

    public ServerBoundPlayerNotificationMenuOpenRequestPacket(int pageNumber, SortDirection sortDirection, String textSearch) {
        this.pageNumber = pageNumber;
        this.sortDirection = sortDirection;
        this.textSearch = textSearch;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pageNumber);
        buffer.m_130068_((Enum)this.sortDirection);
        buffer.m_130070_(this.textSearch);
    }

    public static ServerBoundPlayerNotificationMenuOpenRequestPacket decode(FriendlyByteBuf buffer) {
        int pageNumber = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        String textSearch = buffer.m_130277_();
        return new ServerBoundPlayerNotificationMenuOpenRequestPacket(pageNumber, sortDirection, textSearch);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ModPlayerNotificationService service = Services.getService(ModPlayerNotificationService.class);
            service.showNotificationsForPlayer((ECPlayer)p, this.pageNumber, this.sortDirection, this.textSearch);
        });
    }
}

