/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.packet.ClientBoundPlayerSearchMenuOpenPacket;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.search.PlayerSearchPage;
import com.equestricraft.mod.player.search.PlayerSearchRequest;
import com.equestricraft.mod.player.search.PlayerSearchSession;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlayerSearchMenuRequestPacket {
    private final UUID uuid;
    private final PlayerSearchRequest playerSearchRequest;
    private final int pageNumber;

    public ServerBoundPlayerSearchMenuRequestPacket(UUID uuid, PlayerSearchRequest playerSearchRequest, int pageNumber) {
        this.uuid = uuid;
        this.playerSearchRequest = playerSearchRequest;
        this.pageNumber = pageNumber;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130070_(this.playerSearchRequest.searchText());
        buffer.writeBoolean(this.playerSearchRequest.mustBeOnline());
        buffer.writeBoolean(this.playerSearchRequest.mustBeStarred());
        buffer.writeInt(this.pageNumber);
    }

    public static ServerBoundPlayerSearchMenuRequestPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        String terms = buffer.m_130277_();
        boolean mustBeOnline = buffer.readBoolean();
        boolean mustBeStarred = buffer.readBoolean();
        PlayerSearchRequest playerSearchRequest = new PlayerSearchRequest(terms, mustBeOnline, mustBeStarred);
        int pageNumber = buffer.readInt();
        return new ServerBoundPlayerSearchMenuRequestPacket(uuid, playerSearchRequest, pageNumber);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            PlayerSearchSession playerSearchSession = Services.getService(PlayerSearchSession.class);
            PlayerSearchPage players = playerSearchSession.searchPlayers((ECPlayer)p, this.playerSearchRequest, this.pageNumber);
            ClientBoundPlayerSearchMenuOpenPacket packet = new ClientBoundPlayerSearchMenuOpenPacket(this.uuid, players);
            p.sendPacket(packet);
        });
    }
}

