/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.ModPlayerSettingsService;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundPlayerSettingsUpdatePacket {
    private final Boolean hideChatDuringQuests;
    private final Boolean showPlotMinimap;

    public ServerBoundPlayerSettingsUpdatePacket(Boolean hideChatDuringQuests, Boolean showPlotMinimap) {
        this.hideChatDuringQuests = hideChatDuringQuests;
        this.showPlotMinimap = showPlotMinimap;
    }

    public Boolean getHideChatDuringQuests() {
        return this.hideChatDuringQuests;
    }

    public Boolean getShowPlotMinimap() {
        return this.showPlotMinimap;
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.hideChatDuringQuests != null) {
            buffer.writeBoolean(true);
            buffer.writeBoolean(this.hideChatDuringQuests.booleanValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.showPlotMinimap != null) {
            buffer.writeBoolean(true);
            buffer.writeBoolean(this.showPlotMinimap.booleanValue());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ServerBoundPlayerSettingsUpdatePacket decode(FriendlyByteBuf buffer) {
        Boolean hideChatDuringQuests = buffer.readBoolean() ? Boolean.valueOf(buffer.readBoolean()) : null;
        Boolean showPlotMinimap = buffer.readBoolean() ? Boolean.valueOf(buffer.readBoolean()) : null;
        return new ServerBoundPlayerSettingsUpdatePacket(hideChatDuringQuests, showPlotMinimap);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            ModPlayerSettingsService service = Services.getService(ModPlayerSettingsService.class);
            service.updateSettingsForPlayer((OnlinePlayer)p, this);
        });
    }
}

